% Load Data
load("Figure3G_3S6_Data.mat", 'statTab')

cellcycle = ["All" "G1" "G1S" "S" "G2"];

% calculate delta-K48Ub
conditions = unique(statTab(:,{'SNS','CHX'}));
NN = size(conditions,1);
conditions.deltaIF = cell(NN,1); conditions.cellsize = cell(NN,1);
for nn = 1:NN
    temp = statTab(ismember(statTab(:,{'SNS','CHX'}), conditions(nn,{'SNS','CHX'})),:);
    idx = temp.CFZ==1;
    %conditions.deltaIF{nn} = temp.IF_median(idx,:)-temp.IF_median(~idx,:);
    nrep = sum(idx);
    for cc = 1:length(cellcycle)
        temp1c = repmat(temp.IF_median(idx,cc), nrep, 1);
        temp2c = repmat(temp.IF_median(~idx,cc), 1, nrep); temp2c = temp2c'; temp2c = temp2c(:);
        conditions.deltaIF{nn}(:,cc) = temp1c-temp2c;
        temp1c = repmat(temp.cellsize_median(idx,cc), nrep, 1);
        temp2c = repmat(temp.cellsize_median(idx,cc), 1, nrep); temp2c = temp2c'; temp2c = temp2c(:);
        conditions.cellsize{nn}(:,cc) = (temp1c+temp2c)/2;
    end
end

conditions = sortrows(conditions, {'CHX','SNS'},{'ascend','ascend'});
normFactor = mean(conditions.deltaIF{1}(:,2)); % EG1 of controls

for cc = 2:length(cellcycle)
    figure; clf; hold on
    for nn = 1:NN
        nrep = size(conditions.deltaIF{nn},1);
        temp = conditions.deltaIF{nn}(:,cc)/normFactor;
        bar(nn, mean(temp), 'FaceColor', [1 1 1]*.7, 'BarWidth',0.4);
        scatter(nn+randn(nrep,1)*0.08, temp, 3, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)%scatter(nn+randn(nrep,1)*0.15, temp, 3, [1 1 1]*.3, 'filled','MarkerFaceAlpha',.5)
        errorbar(nn, mean(temp), tinv(.975, nrep-1)*std(temp)/sqrt(nrep), 'k.')
    end   
    xticks(1:NN); xlim([.5 NN+.5]); ylim([0 4]); 
    ylabel('delta-K48Ub'); title(cellcycle(cc))
end

[~, pval] = ttest2(conditions.deltaIF{1}(:,1), conditions.deltaIF{2}(:,1));